<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Add payment method column
            $table->string('payment_method')->default('paypal')->after('coupon_id');
            
            // Add Stripe-specific columns
            $table->json('stripe_data')->nullable()->after('paypal_data');
            $table->string('stripe_session_id')->nullable()->after('stripe_data');
            
            // Update status column to include new statuses
            $table->string('status')->change(); // Make sure it can handle 'expired' status
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn(['payment_method', 'stripe_data', 'stripe_session_id']);
        });
    }
};